<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Top 100 Lietotāji</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<!-- Navigācijas josla -->
<div id="navbar">
    <!-- LOGO poga, kurai ir pievienota onclick funkcija -->
    <div id="logo" onclick="redirectToHomePage()">LOGO</div>
    <!-- Pārējā navigācija -->
    <button onclick="location.href='list_tests.php'">Visi testi</button>
    <button id="createTestBtn" onclick="openTestManagementView()">Testu veidošana</button>
    <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
        <div class="dropdown-content" id="dropdownContent">
            <a href="iestatijumi.html">Iestatījumi</a>
            <a href="vesture.html">Vēsture</a>
            <a href="rezultati.html">Rezultāti</a>
            <a href="testu_parvaldisana.html">Testu pārvaldīšana</a>
            <a href="sakumlapa1.html" onclick="logout()">Iziet</a>
        </div>
    </div>
</div>
<body>
    <h1>Top 100 Lietotāji</h1>
    <table>
        <tr>
            <th>Vieta</th>
            <th>Lietotājvārds</th>
            <th>Rezultāts</th>
        </tr>
        <?php
        $servername = "localhost";
        $username = "root";
        $password = "";
        $dbname = "quiz_db";

        // Izveido savienojumu
        $conn = new mysqli($servername, $username, $password, $dbname);

        // Pārbauda savienojumu
        if ($conn->connect_error) {
            die("Savienojums neizdevās: " . $conn->connect_error);
        }

        // Vaicājums, lai atlasītu top 100 lietotājus pēc rezultātiem
        $sql = "SELECT tr.user_id, tr.score, u.username 
                FROM test_results tr
                LEFT JOIN users u ON tr.user_id = u.id
                ORDER BY tr.score DESC
                LIMIT 100";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            // Izvada datus par katru rindu
            $vieta = 1;
            while($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $vieta . "</td>";
                echo "<td>" . $row["username"] . "</td>";
                echo "<td>" . $row["score"] . "</td>";
                echo "</tr>";
                $vieta++;
            }
        } else {
            echo "<tr><td colspan='3'>Dati nav atrasti</td></tr>";
        }
        $conn->close();
        ?>
    </table>
</body>
</html>
